<?php

namespace Lifestyle\Pimcore\SwooxBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('lifestyle_pimcore_swoox');

        $rootNode
                ->children()
                    ->scalarNode('request_format')->end()
                    ->integerNode('client_id')->end()
                    ->scalarNode('index_url')->end()
                    ->scalarNode('delete_url')->end()
                ->end();

        return $treeBuilder;
    }
}
