<?php

/**
 * Class Config
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SwooxBundle\Export;

use Lifestyle\Pimcore\ExportBundle\Exception\PimcoreExportFailedException;

/**
 * Class Config
 * @package Lifestyle\Pimcore\SwooxBundle\Export
 */
class Config
{
    /**
     * @var int
     */
    private $clientId;

    /**
     * @var string
     */
    private $indexUrl;

    /**
     * @var string
     */
    private $deleteUrl;

    /**
     * @var string
     */
    private $requestFormat;

    /**
     * Config constructor.
     * @param int $clientId
     * @param string $indexUrl
     * @param string $deleteUrl
     * @param string $requestFormat
     */
    public function __construct($clientId, $indexUrl, $deleteUrl, $requestFormat)
    {
        $this->clientId = $clientId;
        $this->indexUrl = $indexUrl;
        $this->deleteUrl = $deleteUrl;
        $this->requestFormat = $requestFormat;
    }

    /**
     * @throws PimcoreExportFailedException
     */
    public function validate()
    {
        if (
            (int) $this->getClientId() <= 0 ||
            strlen($this->getIndexUrl()) <= 0 ||
            strlen($this->getDeleteUrl()) <= 0 ||
            !in_array($this->getRequestFormat(), ['json', 'xml'])
        ) {
            throw new PimcoreExportFailedException('Invalid or missing plugin configuration for swoox export handler!');
        }
    }

    /**
     * @return int
     */
    public function getClientId()
    {
        return $this->clientId;
    }

    /**
     * @return string
     */
    public function getIndexUrl()
    {
        return $this->indexUrl;
    }

    /**
     * @return string
     */
    public function getDeleteUrl()
    {
        return $this->deleteUrl;
    }

    /**
     * @return string
     */
    public function getRequestFormat()
    {
        return $this->requestFormat;
    }
}
