<?php

/**
 * Class Mapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SwooxBundle\Export;

use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;
use Swoox\Api\Model\Request\Delete\Swoox\Item as DeleteRequestItem;
use Swoox\Api\Model\Request\Delete\Swoox\Request as DeleteRequest;
use Swoox\Api\Model\Request\Index\Swoox\Item;
use Swoox\Api\Model\Request\Index\Swoox\NameFieldList;
use Swoox\Api\Model\Request\Index\Swoox\Request;
use Swoox\Api\Model\Request\Index\Swoox\ValueItem;

/**
 * Class Mapper
 * @package Lifestyle\Pimcore\SwooxBundle\Export
 */
class Mapper
{
    /**
     * @param DataCollectorInterface $collector
     * @return Request
     */
    public function mapUpdateRequestModel(DataCollectorInterface $collector)
    {
        $item = (new Item())
            ->setDocumentLanguage('de_DE')
            ->setDocumentPrefix('')
            ->setDocumentRanking('')
            ->setDocumentUniqueKey($collector->getItemValue('id'))
            ->setDocumentTitle('')
            ->setDocumentURL('')
            ->setDocumentText('');

        foreach ($collector->getItems() as $collectorItem) {
            $value = $this->prepareValue($collectorItem->getValue());

            if (is_array($value)) {
                $this->mapMultiValues($item, $collectorItem->getKey(), $value);
            }
            if (!is_array($value)) {
                $this->mapValue($item, $collectorItem->getKey(), $value);
            }
        }

        $request = new Request();
        $request->addItem($item);

        return $request;
    }

    /**
     * @param Item $item
     * @param string $key
     * @param mixed $value
     */
    private function mapValue(Item $item, $key, $value)
    {
        $nameFieldList = new NameFieldList();
        $nameFieldList
            ->setName($key)
            ->setValue($value)
            ->setValueClean($value);

        $item->addDocumentFields($nameFieldList);
    }

    /**
     * @param Item $item
     * @param $key
     * @param array $values
     */
    private function mapMultiValues(Item $item, $key, array $values)
    {
        $valueItems = [];
        foreach ($values as $value) {
            $valueItem = new ValueItem();
            $valueItem->setValue($value);
            $valueItem->setValueClean($value);
            $valueItems[] = $valueItem;
        }

        $nameFieldList = new NameFieldList();
        $nameFieldList
            ->setName($key)
            ->setValues($valueItems);

        $item->addDocumentFields($nameFieldList);
    }

    /**
     * @param mixed $value
     * @return mixed
     */
    private function prepareValue($value)
    {
        if (true === $value) {
            $value = 1;
        }
        if (false === $value) {
            $value = 0;
        }

        return $value;
    }

    /**
     * @param DataCollectorInterface $collector
     * @return DeleteRequest
     */
    public function mapDeleteRequestModel(DataCollectorInterface $collector)
    {
        return (new DeleteRequest())
            ->addItem(
                (new DeleteRequestItem())
                    ->setDocumentUniqueKey($collector->getItemValue('id'))
            );
    }
}
