<?php

/**
 * Class MapperTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\SwooxBundle\Export;

use Lifestyle\Pimcore\ExportBundle\Exception\PimcoreExportFailedException;
use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollector;
use Lifestyle\Pimcore\SwooxBundle\Export\Config;
use Lifestyle\Pimcore\SwooxBundle\Export\Mapper;
use PHPUnit\Framework\TestCase;

/**
 * Class MapperTest
 * @package Tests\Lifestyle\Pimcore\SwooxBundle\Export
 */
class MapperTest extends TestCase
{
    public function testMapUpdateRequestModel()
    {
        $dataCollector = new DataCollector();
        $dataCollector->addItem('id', 'unit_test_id');
        $dataCollector->addItem('itemInt', 12345);
        $dataCollector->addItem('itemString', 'unit_test_string');
        $dataCollector->addItem('itemArray', ['unit_test_array_1', 'unit_test_array_2']);
        $dataCollector->addItem('itemTrue', true);
        $dataCollector->addItem('itemFalse', false);

        $stdObject = new \stdClass();
        $dataCollector->addItem('itemObject', $stdObject);

        $mapper = new Mapper();
        $swooxRequestModel = $mapper->mapUpdateRequestModel($dataCollector);

        $this->assertInstanceOf(\Swoox\Api\Model\Request\Index\Swoox\Request::class, $swooxRequestModel);

        $this->assertCount(1, $swooxRequestModel->getItems());
        $this->assertSame('unit_test_id', $swooxRequestModel->getItems()[0]->getDocumentUniqueKey());

        $this->assertSame('id', $swooxRequestModel->getItems()[0]->getDocumentFields()[0]->getName());
        $this->assertSame('unit_test_id', $swooxRequestModel->getItems()[0]->getDocumentFields()[0]->getValue());

        $this->assertSame('itemInt', $swooxRequestModel->getItems()[0]->getDocumentFields()[1]->getName());
        $this->assertSame(12345, $swooxRequestModel->getItems()[0]->getDocumentFields()[1]->getValue());

        $this->assertSame('itemString', $swooxRequestModel->getItems()[0]->getDocumentFields()[2]->getName());
        $this->assertSame('unit_test_string', $swooxRequestModel->getItems()[0]->getDocumentFields()[2]->getValue());

        $this->assertSame('itemArray', $swooxRequestModel->getItems()[0]->getDocumentFields()[3]->getName());
        $this->assertNull($swooxRequestModel->getItems()[0]->getDocumentFields()[3]->getValue());
        $this->assertSame('unit_test_array_1', $swooxRequestModel->getItems()[0]->getDocumentFields()[3]->getValues()[0]->getValue());
        $this->assertSame('unit_test_array_2', $swooxRequestModel->getItems()[0]->getDocumentFields()[3]->getValues()[1]->getValue());

        $this->assertSame('itemTrue', $swooxRequestModel->getItems()[0]->getDocumentFields()[4]->getName());
        $this->assertSame(1, $swooxRequestModel->getItems()[0]->getDocumentFields()[4]->getValue());

        $this->assertSame('itemFalse', $swooxRequestModel->getItems()[0]->getDocumentFields()[5]->getName());
        $this->assertSame(0, $swooxRequestModel->getItems()[0]->getDocumentFields()[5]->getValue());

        $this->assertSame('itemObject', $swooxRequestModel->getItems()[0]->getDocumentFields()[6]->getName());
        $this->assertSame($stdObject, $swooxRequestModel->getItems()[0]->getDocumentFields()[6]->getValue());
    }

    public function testMapDeleteRequestModel()
    {
        $dataCollector = new DataCollector();
        $dataCollector->addItem('id', 'unit_test_id_delete');

        $mapper = new Mapper();
        $swooxRequestModel = $mapper->mapDeleteRequestModel($dataCollector);

        $this->assertInstanceOf(\Swoox\Api\Model\Request\Delete\Swoox\Request::class, $swooxRequestModel);

        $this->assertCount(1, $swooxRequestModel->getItems());
        $this->assertSame('unit_test_id_delete', $swooxRequestModel->getItems()[0]->getDocumentUniqueKey());
    }
}
