<?php

/**
 * Class Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SwooxBundle\Helper;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use JMS\Serializer\SerializerBuilder;
use JMS\Serializer\SerializerInterface;

/**
 * Class Factory
 * @package Lifestyle\Pimcore\SwooxBundle\Helper
 */
class Factory
{
    /**
     * @var array
     */
    private $factory = [];

    /**
     * @return SerializerInterface
     */
    public function serializer()
    {
        if (!isset($this->factory[__FUNCTION__])) {
            $this->factory[__FUNCTION__] = SerializerBuilder::create()->build();
        }
        return $this->factory[__FUNCTION__];
    }

    /**
     * @return ClientInterface
     */
    public function client()
    {
        if (!isset($this->factory[__FUNCTION__])) {
            $this->factory[__FUNCTION__] = new Client();
        }
        return $this->factory[__FUNCTION__];
    }
}
