<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SwooxBundle\Export;

use Lifestyle\Pimcore\ExportBundle\Exception\PimcoreExportFailedException;
use Lifestyle\Pimcore\ExportBundle\Export\HandlerInterface;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Swoox\RestApiClientBundle\Services\Item\Handler;

/**
 * Class ItemHandler
 * @package Lifestyle\Pimcore\SwooxBundle\Export
 */
class ItemHandler implements HandlerInterface
{
    /**
     * @var Handler
     */
    private $swooxItemHandler;

    /**
     * @param Handler $swooxItemHandler
     */
    public function __construct(Handler $swooxItemHandler)
    {
        $this->swooxItemHandler = $swooxItemHandler;
    }

    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function isResponsible(DataCollectorInterface $collector)
    {
        return $this->swooxItemHandler->isResponsible($collector);
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws PimcoreExportFailedException
     */
    public function publish(DataCollectorInterface $collector)
    {
        try {
            $this->swooxItemHandler->createOrUpdate($collector);
        } catch (\Exception $exception) {
            throw new PimcoreExportFailedException($exception->getMessage());
        }
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws PimcoreExportFailedException
     */
    public function unpublish(DataCollectorInterface $collector)
    {
        try {
            $this->swooxItemHandler->delete($collector);
        } catch (\Exception $exception) {
            throw new PimcoreExportFailedException($exception->getMessage());
        }
    }
}
