<?php

namespace Lifestyle\Pimcore\SwooxBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\Yaml\Yaml;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @link http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class LifestylePimcoreSwooxExtension extends Extension implements PrependExtensionInterface
{
    /**
     * {@inheritdoc}
     */
    public function prepend(ContainerBuilder $container)
    {
        // Prepend needed parameters to avoid a fatal error if the plugin has not been configured correctly
        $container->setParameter('lifestyle_swoox_rest_api_client.client_id', 0);
        $container->setParameter('lifestyle_swoox_rest_api_client.index_url', null);
        $container->setParameter('lifestyle_swoox_rest_api_client.delete_url', null);
        $container->setParameter('lifestyle_swoox_rest_api_client.request_format', 'json');

        $config = Yaml::parse(file_get_contents(__DIR__ . '/../Resources/config/config.yml'));

        if (count($config) > 0) {
            foreach ($config as $key => $configuration) {
                if (is_array($configuration) && count($configuration) > 0) {
                    $container->prependExtensionConfig($key, $configuration);
                }
            }
        }
    }

    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');
    }
}
