<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\SwooxBundle\Export;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\ExportBundle\Exception\PimcoreExportFailedException;
use Lifestyle\Pimcore\SwooxBundle\Export\ItemHandler;
use Lifestyle\Swoox\RestApiClientBundle\Services\HandlerInterface;
use Lifestyle\Swoox\RestApiClientBundle\Services\Item\Handler;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

/**
 * Class ItemHandlerTest
 * @package Tests\Lifestyle\Pimcore\SwooxBundle\Export
 */
class ItemHandlerTest extends TestCase
{
    /**
     * @var HandlerInterface|MockObject
     */
    private $swooxHandlerMock;

    /**
     * @var DataCollectorInterface|MockObject
     */
    protected $dataCollectorMock;

    protected function setUp()
    {
        $this->swooxHandlerMock = $this->getMockBuilder(Handler::class)
            ->disableOriginalConstructor()
            ->setMethods(['isResponsible', 'createOrUpdate', 'delete'])
            ->getMock();

        $this->dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->getMock();
    }

    public function testIsResponsible()
    {
        $this->swooxHandlerMock->expects($this->once())
            ->method('isResponsible')
            ->willReturn(true);

        $handler = new ItemHandler($this->swooxHandlerMock);
        $this->assertTrue($handler->isResponsible($this->dataCollectorMock));
    }

    public function testIsNotResponsible()
    {
        $this->swooxHandlerMock->expects($this->once())
            ->method('isResponsible')
            ->willReturn(false);

        $handler = new ItemHandler($this->swooxHandlerMock);
        $this->assertFalse($handler->isResponsible($this->dataCollectorMock));
    }

    public function testPublishMapsException()
    {
        $this->expectException(PimcoreExportFailedException::class);
        $this->expectExceptionMessage('mocked publish exception');

        $this->swooxHandlerMock->expects($this->once())
            ->method('createOrUpdate')
            ->will($this->throwException(new \Exception('mocked publish exception')));

        $handler = new ItemHandler($this->swooxHandlerMock);
        $handler->publish($this->dataCollectorMock);
    }

    public function testPublishSuccessfully()
    {
        $this->swooxHandlerMock->expects($this->once())
            ->method('createOrUpdate');

        $handler = new ItemHandler($this->swooxHandlerMock);
        $handler->publish($this->dataCollectorMock);
    }

    public function testUnpublishMapsException()
    {
        $this->expectException(PimcoreExportFailedException::class);
        $this->expectExceptionMessage('mocked delete exception');

        $this->swooxHandlerMock->expects($this->once())
            ->method('delete')
            ->will($this->throwException(new \Exception('mocked delete exception')));

        $handler = new ItemHandler($this->swooxHandlerMock);
        $handler->unpublish($this->dataCollectorMock);
    }

    public function testUnpublishSuccessfully()
    {
        $this->swooxHandlerMock->expects($this->once())
            ->method('delete');

        $handler = new ItemHandler($this->swooxHandlerMock);
        $handler->unpublish($this->dataCollectorMock);
    }
}
