# Pimcore5 Export to Swoox API
Install this pimcore5 plugin to export object updates to the Swoox6 Rest API


## Installation

### Prerequisites

1. The base plugin to handle object updates in pimcore5 has to be installed - https://stash.life-style.de/projects/PIM/repos/pimcore5-export/browse.
2. Also make sure you have added the repository in your composer.json file:

```json
    {
        "repositories": [
            {
                  "type": "vcs",
                  "url": "ssh://git@stash.life-style.de:7999/pim/pimcore5-swoox.git"
            }
        ]
    }
```

**3. Register additional bundle:**
```php
// app/AppKernel.php
 
public function registerBundles(): array
{
    if (class_exists('\\Lifestyle\\Swoox\\RestApiClientBundle\\LifestyleSwooxRestApiClientBundle')) {
        $collection->addBundle(new \Lifestyle\Swoox\RestApiClientBundle\LifestyleSwooxRestApiClientBundle());
    }
 
    // ...
}
```


### Installation using composer
```
    composer require lifestyle/pimcore-swoox dev-develop
```

If the plugin has been installed successfully, you can enable it in the pimcore extension manager.


### Configuration

Add the following parameters to your parameters.yml:

    lifestyle_pimcore_swoox.client_id: 123 #The swoox client id
    lifestyle_pimcore_swoox.index_url: "" #The full qualified request url for index or update requests
    lifestyle_pimcore_swoox.delete_url: "" #The full qualified request url for delete requests
    lifestyle_pimcore_swoox.request_format: "json" # The request content type (json|xml)


## Additional documentation

https://intranet.life-style.de/display/MYS/Pimcore+Export


Have fun!
