<?php

/**
 * Class LifestylePimcoreSwooxExtensionTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\SwooxBundle\DependencyInjection;

use Lifestyle\Pimcore\SwooxBundle\DependencyInjection\LifestylePimcoreSwooxExtension;
use Matthias\SymfonyDependencyInjectionTest\PhpUnit\AbstractExtensionTestCase;

/**
 * Class LifestylePimcoreSwooxExtensionTest
 * @package Tests\Lifestyle\Pimcore\SwooxBundle\DependencyInjection
 */
class LifestylePimcoreSwooxExtensionTest extends AbstractExtensionTestCase
{
    protected function getContainerExtensions()
    {
        return array(
            new LifestylePimcoreSwooxExtension()
        );
    }

    public function testRequiredParametersWillBePrependedAsDefault()
    {
        $this->load();

        $this->assertContainerBuilderHasParameter('lifestyle_swoox_rest_api_client.client_id', 0);
        $this->assertContainerBuilderHasParameter('lifestyle_swoox_rest_api_client.index_url', null);
        $this->assertContainerBuilderHasParameter('lifestyle_swoox_rest_api_client.delete_url', null);
        $this->assertContainerBuilderHasParameter('lifestyle_swoox_rest_api_client.request_format', 'json');
    }
}
