# Life-Style - Pimcore Sylius Bundle

Prepares requests for rabbitMQ for export to Sylius using the DataCollector structure. Adds some Sylius-specific properties to the standard pimcore export. It also translates keys and values from the classificationStore to add attribute- and option-support with translations to products and product-variants. 

## Requirements

Pimcore 5.6

## Installation

The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/pim/pimcore5-export.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqconsumerbundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/sb/data-collector-model.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/pimcore-sylius-export-bundle
```

Add the bundle to the kernel. Depending bundles are automatically added. No need to put them into the kernel.

app/AppKernel.php
```php
<?php

use Pimcore\HttpKernel\BundleCollection\BundleCollection;
use Pimcore\Kernel;

class AppKernel extends Kernel
{
    public function registerBundlesToCollection(BundleCollection $collection)
    {
        ...
        $collection->addBundle(new \Lifestyle\Pimcore\Sylius\Export\LifestylePimcoreSyliusExportBundle);
        ...
    }
}
```

## Configuration

You have to configure the [RabbitMqBundle](https://github.com/php-amqplib/RabbitMqBundle) as described in the [LifestyleRabbitMqConsumerBundle](https://stash.life-style.de/projects/LCP/repos/lifestylerabbitmqconsumerbundle).

app/config/config.yml
```yaml
lifestyle_pimcore_sylius_export:
    default_locale: 'en'
    responsible_events: [ 'translation.publish' ]
    translatable_data_object_class_names: [ 'Pimcore\\Model\\DataObject\\Product' ]
    translation_data_object_class_name: 'Pimcore\\Model\\DataObject\\Translation'
```
Use single-quotes in config.yml!
