<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\Sylius\Export\Configuration;

/**
 * Class TranslationConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\Sylius\Export\Configuration
 */
class TranslationConfiguration
{
    /**
     * @var string
     */
    private $defaultLocale;

    /**
     * @var array
     */
    private $responsibleEvents;

    /**
     * @var array
     */
    private $translatableDataObjectClassNames;

    /**
     * @var string
     */
    private $translationDataObjectClassName;

    /**
     * @var array
     */
    private $translatableDataObjectClassIds;

    /**
     * TranslationConfiguration constructor.
     * @param string $defaultLocale
     * @param array $responsibleEvents
     * @param array $translatableDataObjectClassNames
     * @param string $translationDataObjectClassName
     */
    public function __construct(
        string $defaultLocale,
        array $responsibleEvents,
        array $translatableDataObjectClassNames,
        string $translationDataObjectClassName
    ) {
        $this->defaultLocale = $defaultLocale;
        $this->responsibleEvents = $responsibleEvents;
        $this->translatableDataObjectClassNames = $translatableDataObjectClassNames;
        $this->translationDataObjectClassName = $translationDataObjectClassName;
        $this->translatableDataObjectClassIds = array_map(function($className) {
            return (new $className)->getClassId();
        }, $this->translatableDataObjectClassNames);
    }

    /**
     * @return string
     */
    public function getDefaultLocale(): string
    {
        return $this->defaultLocale;
    }

    /**
     * @return array
     */
    public function getResponsibleEvents(): array
    {
        return $this->responsibleEvents;
    }

    /**
     * @return array
     */
    public function getTranslatableDataObjectClassIds(): array
    {
        return $this->translatableDataObjectClassIds;
    }

    /**
     * @return string
     */
    public function getTranslationDataObjectClassName(): string
    {
        return $this->translationDataObjectClassName;
    }
}
