<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\Sylius\Export\Mapping\Field;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\ExportBundle\Mapping\Field\FieldMapperInterface;
use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\Concrete;

/**
 * Class SyliusChannelMapper
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\Sylius\Export\Mapping\Field
 */
class SyliusChannelMapper implements FieldMapperInterface
{
    /**
     * Is the handler capable of handling this input
     *
     * @param Data $property
     *
     * @return boolean
     */
    public function handles(Data $property)
    {
        return $property->getName() === 'channels';
    }

    /**
     * Execute actual handling of given input
     *
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        $channels = [];
        foreach ($object->get('channels') as $channel) {
            $channels[$channel->getCode()] = $channel->getCode();
        }

        $collector->addItem('channels', array_values($channels));
    }
}
