<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Pimcore\Sylius\Export\Mapping\FieldCollectionMapper;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\ExportBundle\Mapping\FieldCollection\FieldCollectionMapperInterface;
use Pimcore\Model\DataObject\Channel;
use Pimcore\Model\DataObject\Concrete;
use Pimcore\Model\DataObject\Fieldcollection\Data\AbstractData;
use Pimcore\Model\DataObject\Fieldcollection\Data\BulkPrice;
use Pimcore\Model\DataObject\TierPriceList;

/**
 * Class SyliusChannelBulkPriceMapper
 *
 * @package Lifestyle\Pimcore\Sylius\Export\Mapping\FieldCollectionMapper
 */
class SyliusChannelBulkPriceMapper implements FieldCollectionMapperInterface
{

    private const BULK_PRICES = 'bulkPrices';

    /**
     * handle
     *
     * @param DataCollectorInterface $collector
     * @param Concrete               $object
     * @param AbstractData           $fieldCollectionItem
     * @return bool
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, AbstractData $fieldCollectionItem): bool
    {
        if (!$this->isResponsible($fieldCollectionItem)) {
            return false;
        }

        $bulkPrices = [];

        // One channel for this field collections is allowed only!
        /** @var Channel $channel */
        $channel = $fieldCollectionItem->getChannel()[0];
        /** @var TierPriceList $priceList */
        $priceList = $fieldCollectionItem->getListname()[0];

        /** @var BulkPrice $fieldCollectionItem */
        $bulkPrices[$channel->getCode() . '_' . $priceList->getId() . '_' . $fieldCollectionItem->getQuantity()] = [
            'channel' => $channel->getCode(),
            'list' => $priceList->getId(),
            'quantity' => $fieldCollectionItem->getQuantity(),
            'price' => $fieldCollectionItem->getPrice()->getValue(),
        ];

        if ($collector->hasItem(self::BULK_PRICES)) {
            $presetPrices = $collector->getItem(self::BULK_PRICES);
            $presetPrices->setValue(array_merge($presetPrices->getValue(), $bulkPrices));
        }

        if (!$collector->hasItem(self::BULK_PRICES)) {
            $collector->addItem(self::BULK_PRICES, $bulkPrices);
        }

        return true;
    }

    /**
     * @param AbstractData $fieldCollectionItem
     * @return bool
     */
    private function isResponsible(AbstractData $fieldCollectionItem): bool
    {
        return 'bulkprice' === strtolower($fieldCollectionItem->getType());
    }
}
