<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\Sylius\Export\Mapping\FieldCollectionMapper;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\ExportBundle\Mapping\FieldCollection\FieldCollectionMapperInterface;
use Pimcore\Model\DataObject\Concrete;
use Pimcore\Model\DataObject\Fieldcollection\Data\AbstractData;

/**
 * Class SyliusChannelPriceMapper
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\FieldCollection
 */
class SyliusChannelPriceMapper implements FieldCollectionMapperInterface
{
    /**
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param AbstractData $fieldCollectionItem
     * @return bool Should return true, if $fieldCollectionItem has been mapped
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, AbstractData $fieldCollectionItem): bool
    {
        if (!$this->isResponsible($fieldCollectionItem)) {
            return false;
        }

        $channelsPrices = [];

        // One channel for this field collections is allowed only!
        $channel = $fieldCollectionItem->getChannel()[0];
        $channelsPrices[$channel->getCode()] = [
            'channel' => $channel->getCode(),
            'price' => $fieldCollectionItem->getPrice()->getValue(),
            'originalPrice' => $fieldCollectionItem->getOriginalPrice()->getValue(),
        ];

        if ($collector->hasItem('channelPrices')) {
            $presetPrices = $collector->getItem('channelPrices');
            $presetPrices->setValue(array_merge($presetPrices->getValue(), $channelsPrices));
        }

        if (!$collector->hasItem('channelPrices')) {
            $collector->addItem('channelPrices', $channelsPrices);
        }

        return true;
    }

    /**
     * @param AbstractData $fieldCollectionItem
     * @return bool
     */
    private function isResponsible(AbstractData $fieldCollectionItem): bool
    {
        return 'pricing' === strtolower($fieldCollectionItem->getFieldname());
    }
}
