<?php

/**
 * Class Config
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SyliusBundle\Export;

use Lifestyle\Pimcore\ExportBundle\Exception\PimcoreExportFailedException;

/**
 * Class Config
 * @package Lifestyle\Pimcore\SyliusBundle\Export
 */
class Config
{
    /**
     * @var string
     */
    private $apiBaseUri;

    /**
     * @var string
     */
    private $apiUserName;

    /**
     * @var string
     */
    private $apiPassword;

    /**
     * @var string
     */
    private $apiTokenUrl;

    /**
     * @var string
     */
    private $apiClientId;

    /**
     * @var string
     */
    private $apiClientSecret;

    /**
     * Config constructor.
     * @param string $apiBaseUri
     * @param string $apiUserName
     * @param string $apiPassword
     * @param string $apiTokenUrl
     * @param string $apiClientId
     * @param string $apiClientSecret
     */
    public function __construct($apiBaseUri, $apiUserName, $apiPassword, $apiTokenUrl, $apiClientId, $apiClientSecret)
    {
        $this->apiBaseUri = $apiBaseUri;
        $this->apiUserName = $apiUserName;
        $this->apiPassword = $apiPassword;
        $this->apiTokenUrl = $apiTokenUrl;
        $this->apiClientId = $apiClientId;
        $this->apiClientSecret = $apiClientSecret;
    }

    /**
     * @throws PimcoreExportFailedException
     */
    public function validate()
    {
        if (
            !strlen($this->getApiBaseUri()) ||
            !strlen($this->getApiUserName()) ||
            !strlen($this->getApiPassword()) ||
            !strlen($this->getApiTokenUrl()) ||
            !strlen($this->getApiClientId()) ||
            !strlen($this->getApiClientSecret())
        ) {
            throw new PimcoreExportFailedException('Invalid or missing plugin configuration for sylius export handler!');
        }
    }

    /**
     * @return string
     */
    public function getApiBaseUri()
    {
        return $this->apiBaseUri;
    }

    /**
     * @return string
     */
    public function getApiUserName()
    {
        return $this->apiUserName;
    }

    /**
     * @return string
     */
    public function getApiPassword()
    {
        return $this->apiPassword;
    }

    /**
     * @return string
     */
    public function getApiTokenUrl()
    {
        return $this->apiTokenUrl;
    }

    /**
     * @return string
     */
    public function getApiClientId()
    {
        return $this->apiClientId;
    }

    /**
     * @return string
     */
    public function getApiClientSecret()
    {
        return $this->apiClientSecret;
    }

    /**
     * @return array
     */
    public function toArray()
    {
        $attributes = array_keys(get_class_vars(self::class));

        $result = [];
        foreach ($attributes as $attribute) {
            $result[$attribute] = $this->$attribute;
        }

        return $result;
    }
}
