<?php

/**
 * Class Mapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SyliusBundle\Export\Product\Version1\Update;

use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\SyliusBundle\Export\Product\Version1\Update\Model\Product;
use Lifestyle\Pimcore\SyliusBundle\Export\Product\Version1\Update\Model\Translation;

/**
 * Class Mapper
 * @package Lifestyle\Pimcore\SyliusBundle\Export\Product\Version1\Update
 */
class Mapper
{
    /**
     * @param DataCollectorInterface $collector
     * @return Product
     */
    public function mapRequestModel(DataCollectorInterface $collector)
    {
        $product = new Product();
        $product->setCode($collector->getItemValue('id'));
        $product->setMainTaxon($collector->getItemValue('mainTaxon'));
        $product->setChannels($collector->getItemValue('channels'));
        $product->setEnabled(true);

        $locales = $collector->getCollectedLocales();
        foreach ($locales as $locale) {
            $translation = new Translation();

            $this->mapTranslationField($translation, $collector, 'name', $locale);
            $this->mapTranslationField($translation, $collector, 'slug', $locale);
            $this->mapTranslationField($translation, $collector, 'description', $locale);
            $this->mapTranslationField($translation, $collector, 'shortDescription', $locale);
            $this->mapTranslationField($translation, $collector, 'metaKeywords', $locale);
            $this->mapTranslationField($translation, $collector, 'metaDescription', $locale);

            $translation->setLocale($locale);
            $product->addTranslation($translation);
        }

        return $product;
    }

    /**
     * @param Translation $translation
     * @param DataCollectorInterface $collector
     * @param string $fieldName
     * @param string $locale
     */
    private function mapTranslationField(Translation $translation, DataCollectorInterface $collector, $fieldName, $locale)
    {
        $collectorItem = $collector->getItem($fieldName);
        if (null !== $collectorItem && $collectorItem->isTranslatable()) {
            $method = 'set' . ucfirst(strtolower($fieldName));
            $translation->$method($collectorItem->getValue($locale));
        }
    }
}
