<?php

/**
 * Class Mapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Update;

use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Handler as TaxonHandler;
use Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Update\Model\Taxon;
use Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Update\Model\Translation;

/**
 * Class Mapper
 * @package Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Update
 */
class Mapper
{
    /**
     * @param DataCollectorInterface $collector
     * @return Taxon
     */
    public function mapRequestModel(DataCollectorInterface $collector)
    {
        $taxon = new Taxon();
        $taxon->setCode($collector->getItemValue('id'));

        $locales = $collector->getCollectedLocales();
        foreach ($locales as $locale) {
            $translation = new Translation();

            $collectorItem = $collector->getItem('name');
            if (null !== $collectorItem && $collectorItem->isTranslatable()) {
                $translation->setName($collectorItem->getValue($locale));
            }

            $collectorItem = $collector->getItem('description');
            if (null !== $collectorItem && $collectorItem->isTranslatable()) {
                $translation->setDescription($collectorItem->getValue($locale));
            }

            $collectorItem = $collector->getItem('slug');
            if (null !== $collectorItem && $collectorItem->isTranslatable()) {
                $translation->setSlug($collectorItem->getValue($locale));
            }

            $translation->setLocale($locale);
            $taxon->addTranslation($translation);
        }

        $this->mapParentTaxon($taxon, $collector);

        return $taxon;
    }

    /**
     * @param Taxon $taxon
     * @param DataCollectorInterface $collector
     */
    private function mapParentTaxon(Taxon $taxon, DataCollectorInterface $collector)
    {
        if (
            $collector->getItemValue('parentId') &&
            TaxonHandler::HANDLER_ID === $collector->getItemValue('parentClassName')
        ) {
            $taxon->setParent($collector->getItemValue('parentId'));
        }
    }
}
