<?php

/**
 * Class LifestylePimcoreSyliusExtensionTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\SwooxBundle\DependencyInjection;

use Lifestyle\Pimcore\SyliusBundle\DependencyInjection\LifestylePimcoreSyliusExtension;
use Matthias\SymfonyDependencyInjectionTest\PhpUnit\AbstractExtensionTestCase;

/**
 * Class LifestylePimcoreSyliusExtensionTest
 * @package Tests\Lifestyle\Pimcore\SwooxBundle\DependencyInjection
 */
class LifestylePimcoreSyliusExtensionTest extends AbstractExtensionTestCase
{
    protected function getContainerExtensions()
    {
        return array(
            new LifestylePimcoreSyliusExtension()
        );
    }

    public function testRequiredParametersWillBePrependedAsDefault()
    {
        $this->load();

        $this->assertContainerBuilderHasParameter('lifestyle_pimcore_sylius.api_base_uri', null);
        $this->assertContainerBuilderHasParameter('lifestyle_pimcore_sylius.api_user_name', null);
        $this->assertContainerBuilderHasParameter('lifestyle_pimcore_sylius.api_password', null);
        $this->assertContainerBuilderHasParameter('lifestyle_pimcore_sylius.api_token_url', null);
        $this->assertContainerBuilderHasParameter('lifestyle_pimcore_sylius.api_client_id', null);
        $this->assertContainerBuilderHasParameter('lifestyle_pimcore_sylius.api_client_secret', null);
    }
}
