<?php

/**
 * Class MapperTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Create;

use JMS\Serializer\SerializerBuilder;
use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollector;
use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Create\Mapper;
use PHPUnit\Framework\TestCase;

/**
 * Class MapperTest
 * @package Tests\Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Create
 */
class MapperTest extends TestCase
{
    public function testMapping()
    {
        $collector = $this->prepareDataCollector();

        $mapper = new Mapper();
        $requestModel = $mapper->mapRequestModel($collector);

        $this->assertSame('123456', $requestModel->getCode());
        $this->assertSame('parentTaxonObjectId', $requestModel->getParent());

        $this->assertCount(2, $requestModel->getTranslations());

        $this->assertSame('English Name', $requestModel->getTranslations()['en_US']->getName());
        $this->assertSame('English Description', $requestModel->getTranslations()['en_US']->getDescription());
        $this->assertSame('English Slug', $requestModel->getTranslations()['en_US']->getSlug());
        $this->assertSame('en_US', $requestModel->getTranslations()['en_US']->getLocale());

        $this->assertSame('German Name', $requestModel->getTranslations()['de_DE']->getName());
        $this->assertSame('German Description', $requestModel->getTranslations()['de_DE']->getDescription());
        $this->assertSame('German Slug', $requestModel->getTranslations()['de_DE']->getSlug());
        $this->assertSame('de_DE', $requestModel->getTranslations()['de_DE']->getLocale());
    }

    public function testSerialization()
    {
        $collector = $this->prepareDataCollector();

        $mapper = new Mapper();
        $requestModel = $mapper->mapRequestModel($collector);

        $serializer = SerializerBuilder::create()->build();
        $json = $serializer->serialize($requestModel, 'json');

        $this->assertSame(
            '{"code":"123456","parent":"parentTaxonObjectId","translations":{"en_US":{"name":"English Name","slug":"English Slug","description":"English Description"},"de_DE":{"name":"German Name","slug":"German Slug","description":"German Description"}}}',
            $json
        );
    }

    /**
     * @return DataCollectorInterface
     */
    private function prepareDataCollector()
    {
        // Add base attributes
        $collector = new DataCollector();
        $collector->addItem('id', '123456');
        $collector->addItem('parentId', 'parentTaxonObjectId');
        $collector->addItem('parentClassName', 'Taxon');

        // Add translated fields
        $item = $collector->addTranslatableItem('name');
        $item->addValue('English Name', 'en_US');
        $item->addValue('German Name', 'de_DE');

        $item = $collector->addTranslatableItem('description');
        $item->addValue('English Description', 'en_US');
        $item->addValue('German Description', 'de_DE');

        $item = $collector->addTranslatableItem('slug');
        $item->addValue('English Slug', 'en_US');
        $item->addValue('German Slug', 'de_DE');

        return $collector;
    }
}
