<?php

/**
 * Class Handler
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SyliusBundle\Export\Product\Version1;

use Lifestyle\Pimcore\ExportBundle\Export\HandlerInterface;
use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;
use Psr\Log\LoggerInterface;

/**
 * Class Handler
 * @package Lifestyle\Pimcore\SyliusBundle\Export\Product\Version1
 */
class Handler implements HandlerInterface
{
    const HANDLER_ID = 'Product';

    /**
     * @var Factory
     */
    private $serviceFactory;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * Handler constructor.
     * @param Factory $serviceFactory
     */
    public function __construct(Factory $serviceFactory, LoggerInterface $logger)
    {
        $this->serviceFactory = $serviceFactory;
        $this->logger = $logger;
    }

    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function isResponsible(DataCollectorInterface $collector)
    {
        return $collector->getItemValue('className') === self::HANDLER_ID;
    }

    /**
     * @param DataCollectorInterface $collector
     */
    public function createOrUpdate(DataCollectorInterface $collector)
    {
        $this->logger->debug('Product Create or Update ...');

        if ($this->serviceFactory->get()->exists($collector->getItemValue('id'))) {
            $this->logger->debug('Product already exists -> Update ...');
            $this->serviceFactory->update()->update($collector);
        } else {
            $this->logger->debug('Product does not exist yet -> Create ...');
            $this->serviceFactory->create()->create($collector);
        }
    }

    /**
     * @param DataCollectorInterface $collector
     */
    public function delete(DataCollectorInterface $collector)
    {
        $this->logger->debug('Product Delete ...');

        if ($this->serviceFactory->get()->exists($collector->getItemValue('id'))) {
            $this->logger->debug('Product exists -> Delete ...');
            $this->serviceFactory->delete()->deleteByCode($collector->getItemValue('id'));
        }
    }
}
