<?php

/**
 * Class Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1;

use Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Create\Handler as CreateHandler;
use Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Delete\Handler as DeleteHandler;
use Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Get\Handler as GetHandler;
use Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Update\Handler as UpdateHandler;

/**
 * Class Factory
 * @package Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1
 */
class Factory
{
    /**
     * @var CreateHandler
     */
    private $createHandler;

    /**
     * @var DeleteHandler
     */
    private $deleteHandler;

    /**
     * @var GetHandler
     */
    private $getHandler;

    /**
     * @var UpdateHandler
     */
    private $updateHandler;

    /**
     * Factory constructor.
     * @param CreateHandler $createHandler
     * @param DeleteHandler $deleteHandler
     * @param GetHandler $getHandler
     * @param UpdateHandler $updateHandler
     */
    public function __construct(CreateHandler $createHandler, DeleteHandler $deleteHandler, GetHandler $getHandler, UpdateHandler $updateHandler)
    {
        $this->createHandler = $createHandler;
        $this->deleteHandler = $deleteHandler;
        $this->getHandler = $getHandler;
        $this->updateHandler = $updateHandler;
    }

    /**
     * @return CreateHandler
     */
    public function create()
    {
        return $this->createHandler;
    }

    /**
     * @return DeleteHandler
     */
    public function delete()
    {
        return $this->deleteHandler;
    }

    /**
     * @return GetHandler
     */
    public function get()
    {
        return $this->getHandler;
    }

    /**
     * @return UpdateHandler
     */
    public function update()
    {
        return $this->updateHandler;
    }
}
