<?php

/**
 * Class Product
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SyliusBundle\Export\Product\Version1\Update\Model\Request;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Product
 * @package Lifestyle\Pimcore\SyliusBundle\Export\Product\Version1\Update\Model\Request
 */
class Product
{
    /**
     * @var string|null
     */
    private $code;

    /**
     * @var bool
     */
    private $enabled = true;

    /**
     * @Serializer\SerializedName("mainTaxon")
     * @var string|null
     */
    private $mainTaxon;

    /**
     * @var array
     */
    private $channels = [];

    /**
     * @var ArrayCollection|Translation[]
     */
    private $translations;

    public function __construct()
    {
        $this->translations = new ArrayCollection();
    }

    /**
     * @return null|string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param null|string $code
     */
    public function setCode($code)
    {
        $this->code = $code;
    }

    /**
     * @return bool
     */
    public function isEnabled()
    {
        return $this->enabled;
    }

    /**
     * @param bool $enabled
     */
    public function setEnabled($enabled)
    {
        $this->enabled = $enabled;
    }

    /**
     * @return null|string
     */
    public function getMainTaxon()
    {
        return $this->mainTaxon;
    }

    /**
     * @param null|string $mainTaxon
     */
    public function setMainTaxon($mainTaxon)
    {
        $this->mainTaxon = $mainTaxon;
    }

    /**
     * @return array
     */
    public function getChannels()
    {
        return $this->channels;
    }

    /**
     * @param array $channels
     */
    public function setChannels($channels)
    {
        $this->channels = $channels;
    }

    /**
     * @param Translation $translation
     */
    public function addTranslation(Translation $translation)
    {
        $this->translations->set($translation->getLocale(), $translation);
    }

    /**
     * @return ArrayCollection|Translation[]
     */
    public function getTranslations()
    {
        return $this->translations;
    }
}
