<?php

/**
 * Class Mapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SyliusBundle\Export\ProductVariant\Version1\Create;

use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\SyliusBundle\Export\ProductVariant\Version1\Create\Model\Request\ChannelPrice;
use Lifestyle\Pimcore\SyliusBundle\Export\ProductVariant\Version1\Create\Model\Request\Product;
use Lifestyle\Pimcore\SyliusBundle\Export\ProductVariant\Version1\Create\Model\Request\Translation;

/**
 * Class Mapper
 * @package Lifestyle\Pimcore\SyliusBundle\Export\ProductVariant\Version1\Create
 */
class Mapper
{
    /**
     * @param DataCollectorInterface $collector
     * @return Product
     */
    public function mapRequestModel(DataCollectorInterface $collector)
    {
        $product = new Product();
        $product
            ->setCode($collector->getItemValue('id'))
            ->setOnHand($collector->getItemValue('onHand'))
            ->setTracked($collector->getItemValue('tracked'))
            //->setTaxCategory($collector->getItemValue('taxCategory'))
            ->setHeight($collector->getItemValue('height'))
            ->setWidth($collector->getItemValue('width'))
            ->setDepth($collector->getItemValue('depth'))
            ->setWeight($collector->getItemValue('weight'))
            ->setVersion($collector->getItemValue('version'));

        if ($collector->hasItem('channelPrices')) {
            foreach ($collector->getItemValue('channelPrices') as $channelCode => $channelPrice) {
                $channelPriceItem = new ChannelPrice();
                $channelPriceItem->setChannel($channelCode);
                $channelPriceItem->setPrice($channelPrice['price']);
                $channelPriceItem->setOriginalPrice($channelPrice['originalPrice']);
                $product->addChannelPricing($channelPriceItem);
            }
        }

        $locales = $collector->getCollectedLocales();
        foreach ($locales as $locale) {
            $translation = new Translation();

            $this->mapTranslationField($translation, $collector, 'name', $locale);

            $translation->setLocale($locale);
            $product->addTranslation($translation);
        }

        return $product;
    }

    /**
     * @param Translation $translation
     * @param DataCollectorInterface $collector
     * @param string $fieldName
     * @param string $locale
     */
    private function mapTranslationField(Translation $translation, DataCollectorInterface $collector, $fieldName, $locale)
    {
        if ($collector->hasItem($fieldName, $locale)) {
            $method = 'set' . ucfirst(strtolower($fieldName));
            $translation->$method($collector->getItemValue($fieldName, $locale));
        }
    }
}
