<?php

/**
 * Class Product
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SyliusBundle\Export\ProductVariant\Version1\Create\Model\Request;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Product
 * @package Lifestyle\Pimcore\SyliusBundle\Export\ProductVariant\Version1\Create\Model\Request
 */
class Product
{
    /**
     * @var string|null
     */
    private $code;

    /**
     * @var bool
     */
    private $tracked = false;

    /**
     * @Serializer\Exclude
     * @Serializer\SerializedName("taxCategory")
     * @var string
     */
    private $taxCategory;

    /**
     * @Serializer\SerializedName("onHand")
     * @var int
     */
    private $onHand;

    /**
     * @var int
     */
    private $height;

    /**
     * @var int
     */
    private $width;

    /**
     * @var int
     */
    private $depth;

    /**
     * @var int
     */
    private $weight;

    /**
     * @var int
     */
    private $version;

    /**
     * @var ArrayCollection|Translation[]
     */
    private $translations;

    /**
     * @Serializer\SerializedName("channelPricings")
     * @var ArrayCollection|ChannelPrice[]
     */
    private $channelPricing;


    public function __construct()
    {
        $this->translations = new ArrayCollection();
        $this->channelPricing = new ArrayCollection();
    }

    /**
     * @return null|string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param null|string $code
     * @return Product
     */
    public function setCode($code)
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @param Translation $translation
     */
    public function addTranslation(Translation $translation)
    {
        $this->translations->set($translation->getLocale(), $translation);
    }

    /**
     * @return ArrayCollection|Translation[]
     */
    public function getTranslations()
    {
        return $this->translations;
    }

    /**
     * @param ChannelPrice $pricing
     */
    public function addChannelPricing(ChannelPrice $pricing)
    {
        $this->channelPricing->set($pricing->getChannel(), $pricing);
    }

    /**
     * @return ArrayCollection|ChannelPrice[]
     */
    public function getChannelPricing()
    {
        return $this->channelPricing;
    }

    /**
     * @return int
     */
    public function getOnHand()
    {
        return $this->onHand;
    }

    /**
     * @param int $onHand
     * @return Product
     */
    public function setOnHand($onHand)
    {
        $this->onHand = $onHand;
        return $this;
    }

    /**
     * @return bool
     */
    public function isTracked()
    {
        return $this->tracked;
    }

    /**
     * @param bool $tracked
     * @return Product
     */
    public function setTracked($tracked)
    {
        $this->tracked = $tracked;
        return $this;
    }

    /**
     * @return string
     */
    public function getTaxCategory()
    {
        return $this->taxCategory;
    }

    /**
     * @param string $taxCategory
     * @return Product
     */
    public function setTaxCategory($taxCategory)
    {
        $this->taxCategory = $taxCategory;
        return $this;
    }

    /**
     * @return int
     */
    public function getHeight()
    {
        return $this->height;
    }

    /**
     * @param int $height
     * @return Product
     */
    public function setHeight($height)
    {
        $this->height = $height;
        return $this;
    }

    /**
     * @return int
     */
    public function getWidth()
    {
        return $this->width;
    }

    /**
     * @param int $width
     * @return Product
     */
    public function setWidth($width)
    {
        $this->width = $width;
        return $this;
    }

    /**
     * @return int
     */
    public function getDepth()
    {
        return $this->depth;
    }

    /**
     * @param int $depth
     * @return Product
     */
    public function setDepth($depth)
    {
        $this->depth = $depth;
        return $this;
    }

    /**
     * @return int
     */
    public function getWeight()
    {
        return $this->weight;
    }

    /**
     * @param int $weight
     * @return Product
     */
    public function setWeight($weight)
    {
        $this->weight = $weight;
        return $this;
    }

    /**
     * @return int
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * @param int $version
     * @return Product
     */
    public function setVersion($version)
    {
        $this->version = $version;
        return $this;
    }
}
