<?php

/**
 * Class Mapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Create;

use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Create\Model\Request\Taxon;
use Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Create\Model\Request\Translation;
use Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Handler as TaxonHandler;

/**
 * Class Mapper
 * @package Lifestyle\Pimcore\SyliusBundle\Export\Taxon\Version1\Create
 */
class Mapper
{
    /**
     * @param DataCollectorInterface $collector
     * @return Taxon
     */
    public function mapRequestModel(DataCollectorInterface $collector)
    {
        $taxon = new Taxon();
        $taxon->setCode($collector->getItemValue('id'));

        $locales = $collector->getCollectedLocales();
        foreach ($locales as $locale) {
            $translation = new Translation();

            $this->mapTranslationField($translation, $collector, 'name', $locale);
            $this->mapTranslationField($translation, $collector, 'description', $locale);
            $this->mapTranslationField($translation, $collector, 'slug', $locale);

            $translation->setLocale($locale);
            $taxon->addTranslation($translation);
        }

        $this->mapParentTaxon($taxon, $collector);

        return $taxon;
    }

    /**
     * @param Translation $translation
     * @param DataCollectorInterface $collector
     * @param string $fieldName
     * @param string $lang
     */
    private function mapTranslationField(Translation $translation, DataCollectorInterface $collector, $fieldName, $lang)
    {
        if ($collector->hasItem($fieldName, $lang)) {
            $method = 'set' . ucfirst(strtolower($fieldName));
            $translation->$method($collector->getItemValue($fieldName, $lang));
        }
    }

    /**
     * @param Taxon $taxon
     * @param DataCollectorInterface $collector
     */
    private function mapParentTaxon(Taxon $taxon, DataCollectorInterface $collector)
    {
        if (
            $collector->getItemValue('parentId') &&
            TaxonHandler::HANDLER_ID === $collector->getItemValue('parentClassName')
        ) {
            $taxon->setParent($collector->getItemValue('parentId'));
        }
    }
}
