<?php

/**
 * Class Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SyliusBundle\Helper;

use JMS\Serializer\SerializerBuilder;
use JMS\Serializer\SerializerInterface;

/**
 * Class Factory
 *
 * This factory helps us, to ensure plug-and-play for this pimcore plugin.
 * For instance, when we use the serializer bundle we have to enable it in the AppKernel.
 * This way, you can not just enable the pimcore plugin and hope it will work directly.
 *
 * @package Lifestyle\Pimcore\SyliusBundle\Helper
 */
class Factory
{
    /**
     * @var array
     */
    private $factory = [];

    /**
     * @return SerializerInterface
     */
    public function serializer()
    {
        if (!isset($this->factory[__FUNCTION__])) {
            $this->factory[__FUNCTION__] = SerializerBuilder::create()->build();
        }
        return $this->factory[__FUNCTION__];
    }
}
