<?php

/**
 * Class SessionTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\SyliusBundle\Persistence;

use Lifestyle\Pimcore\SyliusBundle\Persistence\Session;
use PHPUnit\Framework\TestCase;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

/**
 * Class SessionTest
 * @package Tests\Lifestyle\Pimcore\SyliusBundle\Persistence
 */
class SessionTest extends TestCase
{
    public function testLoadExistingAttribute()
    {
        $session = $this->getMockBuilder(SessionInterface::class)
            ->disableOriginalConstructor()
            ->setMethods([])
            ->getMock();
        $session->expects($this->once())
            ->method('has')
            ->with('existingAttribute')
            ->willReturn(true);
        $session->expects($this->once())
            ->method('get')
            ->with('existingAttribute')
            ->willReturn('test_value');

        $persistenceSession = new Session($session);

        $this->assertSame('test_value', $persistenceSession->load('existingAttribute'));
    }

    public function testLoadUnknownAttribute()
    {
        $session = $this->getMockBuilder(SessionInterface::class)
            ->disableOriginalConstructor()
            ->setMethods([])
            ->getMock();
        $session->expects($this->once())
            ->method('has')
            ->willReturn(false);
        $session->expects($this->never())
            ->method('get');

        $persistenceSession = new Session($session);

        $this->assertNull($persistenceSession->load('unknownAttribute'));
    }

    public function testPersist()
    {
        $session = $this->getMockBuilder(SessionInterface::class)
            ->disableOriginalConstructor()
            ->setMethods([])
            ->getMock();
        $session->expects($this->once())
            ->method('set')
            ->with('newAttribute', 'test_value');

        $persistenceSession = new Session($session);
        $persistenceSession->persist('newAttribute', 'test_value');
    }
}
