<?php

/**
 * Class ProductVariantHandlerTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\SyliusBundle\Export;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\ExportBundle\Exception\PimcoreExportFailedException;
use Lifestyle\Pimcore\SyliusBundle\Export\ProductVariantHandler;
use Lifestyle\Sylius\RestApiClientBundle\Services\HandlerInterface;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Handler;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

/**
 * Class ProductVariantHandlerTest
 * @package Tests\Lifestyle\Pimcore\SyliusBundle\Export
 */
class ProductVariantHandlerTest extends TestCase
{
    /**
     * @var HandlerInterface|MockObject
     */
    private $syliusHandlerMock;

    /**
     * @var DataCollectorInterface|MockObject
     */
    protected $dataCollectorMock;

    protected function setUp()
    {
        $this->syliusHandlerMock = $this->getMockBuilder(Handler::class)->disableOriginalConstructor()->getMock();
        $this->dataCollectorMock = $this->getMockBuilder(DataCollectorInterface::class)->getMock();
    }

    public function testIsResponsible()
    {
        $this->syliusHandlerMock->expects($this->once())
            ->method('isResponsible')
            ->willReturn(true);

        $handler = new ProductVariantHandler($this->syliusHandlerMock);
        $this->assertTrue($handler->isResponsible($this->dataCollectorMock));
    }

    public function testIsNotResponsible()
    {
        $this->syliusHandlerMock->expects($this->once())
            ->method('isResponsible')
            ->willReturn(false);

        $handler = new ProductVariantHandler($this->syliusHandlerMock);
        $this->assertFalse($handler->isResponsible($this->dataCollectorMock));
    }

    public function testPublishMapsException()
    {
        $this->expectException(PimcoreExportFailedException::class);
        $this->expectExceptionMessage('mocked publish exception');

        $this->syliusHandlerMock->expects($this->once())
            ->method('createOrUpdate')
            ->will($this->throwException(new \Exception('mocked publish exception')));

        $handler = new ProductVariantHandler($this->syliusHandlerMock);
        $handler->publish($this->dataCollectorMock);
    }

    public function testPublishSuccessfully()
    {
        $this->syliusHandlerMock->expects($this->once())
            ->method('createOrUpdate');

        $handler = new ProductVariantHandler($this->syliusHandlerMock);
        $handler->publish($this->dataCollectorMock);
    }

    public function testUnpublishMapsException()
    {
        $this->expectException(PimcoreExportFailedException::class);
        $this->expectExceptionMessage('mocked delete exception');

        $this->syliusHandlerMock->expects($this->once())
            ->method('delete')
            ->will($this->throwException(new \Exception('mocked delete exception')));

        $handler = new ProductVariantHandler($this->syliusHandlerMock);
        $handler->unpublish($this->dataCollectorMock);
    }

    public function testUnpublishSuccessfully()
    {
        $this->syliusHandlerMock->expects($this->once())
            ->method('delete');

        $handler = new ProductVariantHandler($this->syliusHandlerMock);
        $handler->unpublish($this->dataCollectorMock);
    }
}
