<?php

/**
 * Class ProductHandler
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SyliusBundle\Export;

use Lifestyle\Pimcore\ExportBundle\Exception\PimcoreExportFailedException;
use Lifestyle\Pimcore\ExportBundle\Export\HandlerInterface;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Handler;

/**
 * Class ProductHandler
 * @package Lifestyle\Pimcore\SyliusBundle\Export
 */
class ProductHandler implements HandlerInterface
{
    /**
     * @var Handler
     */
    private $syliusProductHandler;

    /**
     * @param Handler $syliusProductHandler
     */
    public function __construct(Handler $syliusProductHandler)
    {
        $this->syliusProductHandler = $syliusProductHandler;
    }

    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function isResponsible(DataCollectorInterface $collector)
    {
        return $this->syliusProductHandler->isResponsible($collector);
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws PimcoreExportFailedException
     */
    public function publish(DataCollectorInterface $collector)
    {
        try {
            $this->syliusProductHandler->createOrUpdate($collector);
        } catch (\Exception $exception) {
            throw new PimcoreExportFailedException($exception->getMessage());
        }
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws PimcoreExportFailedException
     */
    public function unpublish(DataCollectorInterface $collector)
    {
        try {
            $this->syliusProductHandler->delete($collector);
        } catch (\Exception $exception) {
            throw new PimcoreExportFailedException($exception->getMessage());
        }
    }
}
