<?php

/**
 * Class ConfigurationTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\SyliusBundle\DependencyInjection;

use Lifestyle\Pimcore\SyliusBundle\DependencyInjection\Configuration;
use Matthias\SymfonyConfigTest\PhpUnit\ConfigurationTestCaseTrait;
use PHPUnit\Framework\TestCase;

/**
 * Class ConfigurationTest
 * @package Tests\Lifestyle\Pimcore\SyliusBundle\DependencyInjection
 */
class ConfigurationTest extends TestCase
{
    use ConfigurationTestCaseTrait;

    protected function getConfiguration()
    {
        return new Configuration();
    }

    public function testDefaultValueIsSet()
    {
        $this->assertProcessedConfigurationEquals([], ['version' => '1']);
    }

    public function testOverwriteDefaultVersion()
    {
        $this->assertProcessedConfigurationEquals([['version' => '2']], ['version' => '2']);
    }
}
