# Pimcore5 Export to Sylius
Install this pimcore5 plugin to export object updates to the Sylius Rest API for:
- **Products**
- **ProductVariants**
- **Taxons**
- **ProductOptions**


## Installation

### Prerequisites

1. The base plugin to handle object updates in pimcore5 has to be installed - https://stash.life-style.de/projects/PIM/repos/pimcore5-export/browse.
2. Also make sure you have added the repository in your composer.json file:

```json
    {
        "repositories": [
            {
                  "type": "vcs",
                  "url": "ssh://git@stash.life-style.de:7999/pim/pimcore5-sylius.git"
            }
        ]
    }
```

**3. Register additional bundle:**
```php
// app/AppKernel.php
 
public function registerBundles(): array
{
    if (class_exists('\\Lifestyle\\Sylius\\RestApiClientBundle\\LifestyleSyliusRestApiClientBundle')) {
        $collection->addBundle(new \Lifestyle\Sylius\RestApiClientBundle\LifestyleSyliusRestApiClientBundle());
    }
 
    // ...
}
```


### Installation using composer
```
    composer require lifestyle/pimcore-sylius dev-develop
```

If the plugin has been installed successfully, you can enable it in the pimcore extension manager.


### Configuration

This plugin uses https://stash.life-style.de/projects/SB/repos/sylius-rest-client/browse to connect the Sylius REST API.
Therefore, you must add some parameters to your parameters.yml.
Attention: The following list could be outdated!


```yaml
lifestyle_sylius_rest_api_client.api_base_uri: "http://sylius.localhost"
lifestyle_sylius_rest_api_client.api_user_name: "api@example.com"
lifestyle_sylius_rest_api_client.api_password: "sylius-api"
lifestyle_sylius_rest_api_client.api_token_url: "/api/oauth/v2/token"
lifestyle_sylius_rest_api_client.api_client_id: "demo_client"
lifestyle_sylius_rest_api_client.api_client_secret: "secret_demo_client"
```


#### Versioning

https://stash.life-style.de/projects/SB/repos/sylius-rest-client/browse provides a version setting.
Have a look at it's documentation because the following example could already be outdated:

```yaml
lifestyle_sylius_rest_api_client:
    version: '1'
```


## Additional documentation

- https://intranet.life-style.de/display/MYS/Pimcore+Export
- https://stash.life-style.de/projects/SB/repos/sylius-rest-client/browse

Have fun!
