<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\Taxon\Model;

use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Class TaxonMapper
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\Taxon\Model
 */
class TaxonMapper
{
    /**
     * @var Factory
     */
    private $factory;

    /**
     * TaxonMapper constructor.
     * @param Factory $factory
     */
    public function __construct(Factory $factory)
    {
        $this->factory = $factory;
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @return Taxon
     */
    public function mapTaxon(DataCollectorInterface $dataCollector): Taxon
    {
        $taxonData = $this->factory->taxon();

        if ($dataCollector->hasItem('id')) {
            $taxonData->setId((int)$dataCollector->getItemValue('id'));
        }

        foreach ($dataCollector->getCollectedLocales() as $locale) {
            if ($dataCollector->hasItem('url', $locale)) {
                $taxonTranslationData = $this->factory->taxonTranslation();
                $taxonTranslationData->setLocale($locale);
                $taxonTranslationData->setUrl((string)$dataCollector->getItemValue('url', $locale));
                $taxonData->addTaxonTranslation($taxonTranslationData);
            }
        }

        return $taxonData;
    }
}
