<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\Taxon\DependencyInjection;

use Lifestyle\Pimcore\Taxon\Configuration\TaxonConfiguration;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;

/**
 * Class LifestylePimcoreTaxonExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\Taxon\DependencyInjection
 */
class LifestylePimcoreTaxonExtension extends Extension
{
    /**
     * Loads a specific configuration.
     *
     * @param array $configs
     * @param ContainerBuilder $container
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = $this->getConfiguration($configs, $container);
        $config = $this->processConfiguration($configuration, $configs);

        (new XmlFileLoader($container, new FileLocator(dirname(__DIR__) . '/Resources/config')))->load('services.xml');

        $this->setTaxonConfiguration($config, $container);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function setTaxonConfiguration(array $config, ContainerBuilder $container)
    {
        if (!$container->has(TaxonConfiguration::class)) {
            return;
        }

        $definition = $container->findDefinition(TaxonConfiguration::class);
        $definition->setArguments([
            $config['taxon_url_property'],
        ]);
    }
}
