# Life-Style - Pimcore Taxon Bundle

Updates taxon urls in Pimcore.

The bundle receives messages sent by the [Lifestyle-Sulu-Taxon-Bundle](http://https://stash.life-style.de/projects/LCP/repos/lifestylesulutaxonbundle/browse) using the [RabbitMQ](https://www.rabbitmq.com). It uses the Life-Style [Data-Collector-Structure](https://stash.life-style.de/projects/SB/repos/data-collector-model).

## Requirements

Pimcore 5.6

## Installation

The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylepimcoretaxonbundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqconsumerbundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/sb/data-collector-model.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/pimcore-taxon-bundle
```

Add the bundle to the kernel:

app/AppKernel.php
```php
<?php

use Pimcore\HttpKernel\BundleCollection\BundleCollection;
use Pimcore\Kernel;

class AppKernel extends Kernel
{
    public function registerBundlesToCollection(BundleCollection $collection)
    {
        ...
        $collection->addBundle(new \Lifestyle\Pimcore\Taxon\LifestylePimcoreTaxonBundle);
        ...
    }
}
```

## Configuration

You have to configure the [RabbitMqBundle](https://github.com/php-amqplib/RabbitMqBundle) as described in the [LifestyleRabbitMqConsumerBundle](http://https://stash.life-style.de/projects/LCP/repos/lifestylerabbitmqconsumerbundle/browse).

