<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\Taxon\Configuration;

/**
 * Class TaxonConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\Taxon\Configuration
 */
class TaxonConfiguration
{
    /**
     * @var string
     */
    private $urlPropertyName;

    /**
     * TaxonConfiguration constructor.
     * @param string $urlPropertyName
     */
    public function __construct(string $urlPropertyName)
    {
        $this->urlPropertyName = $urlPropertyName;
    }

    /**
     * @return string
     */
    public function getUrlPropertyName(): string
    {
        return $this->urlPropertyName;
    }
}
