<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\Taxon\Model;

use Symfony\Component\Validator\Constraints as Assert;
use Lifestyle\Pimcore\Taxon\Validator\Constraints as LsAssert;

/**
 * Class Taxon
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\Taxon\Model
 */
class Taxon
{
    /**
     * @Assert\NotNull(message="Object-id should not be null.")
     * @Assert\GreaterThan(message="Invalid object-id.", value=0)
     * @LsAssert\Taxon()
     * @var int
     */
    private $id;

    /**
     * @Assert\NotNull()
     * @Assert\Valid()
     * @var TaxonTranslation[]
     */
    private $taxonTranslations;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId(int $id): void
    {
        $this->id = $id;
    }

    /**
     * @return TaxonTranslation[]
     */
    public function getTaxonTranslations(): array
    {
        return $this->taxonTranslations;
    }

    /**
     * @param TaxonTranslation $translation
     */
    public function addTaxonTranslation(TaxonTranslation $translation): void
    {
        $this->taxonTranslations[] = $translation;
    }
}
