# Life-Style - Pimcore Translation Bundle

Receives messages from rabbitMQ and updates objects values from ClassificationStore.

## Requirements

Pimcore 5.6

## Installation

The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylepimcoreorderinventorybundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqconsumerbundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/sb/data-collector-model.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/pimcore-translation-bundle
```

Add the bundle to the kernel:

app/AppKernel.php
```php
<?php

use Pimcore\HttpKernel\BundleCollection\BundleCollection;
use Pimcore\Kernel;

class AppKernel extends Kernel
{
    public function registerBundlesToCollection(BundleCollection $collection)
    {
        ...
        $collection->addBundle(new \Lifestyle\Pimcore\Translation\LifestylePimcoreTranslationBundle);
        ...
    }
}
```

## Configuration

You have to configure the [RabbitMqBundle](https://github.com/php-amqplib/RabbitMqBundle) as described in the [LifestyleRabbitMqConsumerBundle](https://stash.life-style.de/projects/LCP/repos/lifestylerabbitmqconsumerbundle).

app/config/config.yml
```yaml
lifestyle_pimcore_translation:
    default_locale: 'en'
    responsible_events: [ 'translation.publish' ]
    translatable_data_object_class_names: [ 'Pimcore\\Model\\DataObject\\Product' ]
    translation_data_object_class_name: 'Pimcore\\Model\\DataObject\\Translation'
```
