<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\Translation\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\Translation\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * Generates the configuration tree builder.
     *
     * @return TreeBuilder The tree builder
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $treeBuilder
            ->root('lifestyle_pimcore_translation')
                ->children()
                    ->scalarNode('default_locale')
                        ->cannotBeEmpty()
                        ->defaultValue('en')
                    ->end()
                    ->arrayNode('responsible_events')
                        ->scalarPrototype()->end()
                        ->example('translation.publish')
                        ->info('A list of events listen to.')
                    ->end()
                    ->arrayNode('translatable_data_object_class_names')
                        ->scalarPrototype()->end()
                        ->example('Pimcore\\Model\\DataObject\\Product')
                    ->end()
                    ->scalarNode('translation_data_object_class_name')
                        ->cannotBeEmpty()
                        ->defaultValue('Pimcore\\Model\\DataObject\\Translation')
                    ->end()
                ->end()
        ;

        return $treeBuilder;
    }
}
