<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg,Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ProtocolServiceSdk\Model;

use DateTimeImmutable;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class ProtocolCriteria
 * @package LifeStyle\ProtocolServiceSdk\Model
 *
 * @Serializer\AccessType(type=JMS\Serializer\Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(policy=Serializer\ExclusionPolicy::ALL)
 */
class ProtocolCriteria
{
    // TODO: order by constants
    /**
     * @var boolean|null
     *
     * @Serializer\Type("bool")
     * @Serializer\SerializedName("sent_flag")
     * @Serializer\Expose()
     */
    private $sentFlag;

    /**
     * @var string|null
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("client")
     * @Serializer\Expose()
     */
    private $client;

    /**
     * @var DateTimeImmutable
     *
     * @Serializer\Type("DateTimeImmutable")
     * @Serializer\SerializedName("time_anchor")
     * @Serializer\Expose()
     */
    private $timeAnchor;

    /**
     * @var string
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("timeframe")
     * @Serializer\Expose()
     */
    private $timeframe;

    /**
     * @var string|null
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("source")
     * @Serializer\Expose()
     */
    private $source;

    /**
     * @var array|string[]|null
     *
     * @Serializer\Type("array<string, string>")
     * @Serializer\SerializedName("order_by")
     * @Serializer\Expose()
     */
    private $orderBy;

    /**
     * @var integer|null
     *
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("limit")
     * @Serializer\Expose()
     */
    private $limit;

    /**
     * @var integer|null
     *
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("offset")
     * @Serializer\Expose()
     */
    private $offset;

    /**
     * @return bool
     */
    public function hasSentFlag(): bool
    {
        return !empty($this->sentFlag);
    }

    /**
     * @return bool
     */
    public function hasClient(): bool
    {
        return !empty($this->client);
    }

    /**
     * @return bool
     */
    public function hasTimeAnchor(): bool
    {
        return !empty($this->timeAnchor);
    }

    /**
     * @return bool
     */
    public function hasTimeframe(): bool
    {
        return !empty($this->timeframe);
    }

    /**
     * @return bool
     */
    public function hasSource(): bool
    {
        return !empty($this->source);
    }

    /**
     * @return bool
     */
    public function hasOrderBy(): bool
    {
        return !empty($this->orderBy);

    }

    /**
     * @return bool
     */
    public function hasLimit(): bool
    {
        return !empty($this->limit);

    }

    /**
     * @return bool
     */
    public function hasOffset(): bool
    {
        return !empty($this->offset);

    }

    /**
     * @return bool|null
     */
    public function getSentFlag(): ?bool
    {
        return $this->sentFlag;
    }

    /**
     * @param bool|null $sentFlag
     * @return ProtocolCriteria
     */
    public function setSentFlag(?bool $sentFlag): ProtocolCriteria
    {
        $this->sentFlag = $sentFlag;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getClient(): ?string
    {
        return $this->client;
    }

    /**
     * @param string|null $client
     * @return ProtocolCriteria
     */
    public function setClient(?string $client): ProtocolCriteria
    {
        $this->client = $client;
        return $this;
    }

    /**
     * @return DateTimeImmutable
     */
    public function getTimeAnchor(): DateTimeImmutable
    {
        return $this->timeAnchor ?? new DateTimeImmutable();
    }

    /**
     * @param DateTimeImmutable $timeAnchor
     * @return ProtocolCriteria
     */
    public function setTimeAnchor(DateTimeImmutable $timeAnchor): ProtocolCriteria
    {
        $this->timeAnchor = $timeAnchor;
        return $this;
    }

    /**
     * @return string
     */
    public function getTimeframe(): string
    {
        return $this->timeframe;
    }

    /**
     * @param string $timeframe
     * @return ProtocolCriteria
     */
    public function setTimeframe(string $timeframe): ProtocolCriteria
    {
        $this->timeframe = $timeframe;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSource(): ?string
    {
        return $this->source;
    }

    /**
     * @param string|null $source
     * @return ProtocolCriteria
     */
    public function setSource(?string $source): ProtocolCriteria
    {
        $this->source = $source;
        return $this;
    }

    /**
     * @return array|string[]|null
     */
    public function getOrderBy(): ?array
    {
        return $this->orderBy;
    }

    /**
     * @param array|string[]|null $orderBy
     * @return ProtocolCriteria
     */
    public function setOrderBy(?array $orderBy): ProtocolCriteria
    {
        $this->orderBy = $orderBy;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getLimit(): ?int
    {
        return $this->limit;
    }

    /**
     * @param int|null $limit
     * @return ProtocolCriteria
     */
    public function setLimit(?int $limit): ProtocolCriteria
    {
        $this->limit = $limit;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getOffset(): ?int
    {
        return $this->offset;
    }

    /**
     * @param int|null $offset
     * @return ProtocolCriteria
     */
    public function setOffset(?int $offset): ProtocolCriteria
    {
        $this->offset = $offset;
        return $this;
    }
}
