<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg,Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ProtocolServiceSdk\Model;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ProtocolList
 * @package LifeStyle\ProtocolServiceSdk\Model
 *
 * @Serializer\AccessType(type=JMS\Serializer\Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(policy=Serializer\ExclusionPolicy::ALL)
 */
class ProtocolList
{
    /**
     * @var array|Protocol[]
     *
     * @Serializer\Type("array<LifeStyle\ProtocolServiceSdk\Model\Protocol>")
     * @Serializer\SerializedName("list")
     * @Serializer\Expose()
     */
    private $list;

    /**
     * @return Protocol[]|array
     */
    public function getList(): array
    {
        return $this->list;
    }

    /**
     * @param Protocol[]|array $list
     * @return ProtocolList
     */
    public function setList(array $list): ProtocolList
    {
        $this->list = $list;
        return $this;
    }
}
