<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg,Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ProtocolServiceSdk\Exception;

use Exception;
use Psr\Http\Client\ClientExceptionInterface;

/**
 * Class ProtocolServiceSdkException
 * @package LifeStyle\ProtocolServiceSdk\Service
 */
class ProtocolServiceSdkException extends Exception
{
    /**
     * @param Exception $exception
     * @throws ProtocolServiceSdkException
     */
    public static function withOtherException(Exception $exception)
    {
        throw new self("General application error: {$exception->getMessage()}", $exception->getCode(), $exception);
    }

    /**
     * @param ClientExceptionInterface $exception
     * @throws ProtocolServiceSdkException
     */
    public static function withGuzzleException(ClientExceptionInterface $exception)
    {
        throw new self("HTTP Exception: {$exception->getMessage()}", $exception->getCode(), $exception);
    }
}
