<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg,Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace LifeStyle\ProtocolServiceSdk\Model;

use DateTimeImmutable;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Protocol
 * @package LifeStyle\ProtocolServiceSdk\Model
 *
 * @Serializer\AccessType(type=JMS\Serializer\Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(policy=Serializer\ExclusionPolicy::ALL)
 */
class Protocol
{
    /**
     * @var integer|null
     *
     * @Serializer\Type("int")
     * @Serializer\SerializedName("id")
     * @Serializer\Expose()
     */
    private $id;

    /**
     * @var string
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("client")
     * @Serializer\Expose()
     */
    private $client;

    /**
     * @var array|ProtocolLine[]
     *
     * @Serializer\Type("array<LifeStyle\ProtocolServiceSdk\Model\ProtocolLine>")
     * @Serializer\SerializedName("line_list")
     * @Serializer\Expose()
     */
    private $lineList = [];

    /**
     * @var boolean
     *
     * @Serializer\Type("bool")
     * @Serializer\SerializedName("sent_flag")
     * @Serializer\Expose()
     */
    private $sentFlag = false;

    /**
     * @var DateTimeImmutable|null
     *
     * @Serializer\Type("DateTimeImmutable")
     * @Serializer\SerializedName("sent_date")
     * @Serializer\Expose()
     */
    private $sentDate;

    /**
     * @var DateTimeImmutable|null
     *
     * @Serializer\Type("DateTimeImmutable")
     * @Serializer\SerializedName("create_date")
     * @Serializer\Expose()
     */
    private $createDate;

    /**
     * @var DateTimeImmutable
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("source")
     * @Serializer\Expose()
     */
    private $source;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return Protocol
     * @deprecated Do not use this, because it is set automatically on the server-side. Will be reset anyway. {@see Protocol::onPreSerialize()}
     */
    public function setId(?int $id): Protocol
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getClient(): string
    {
        return $this->client;
    }

    /**
     * @param string $client
     * @return Protocol
     */
    public function setClient(string $client): Protocol
    {
        $this->client = $client;

        return $this;
    }

    /**
     * @return array|ProtocolLine[]
     */
    public function getLineList(): array
    {
        return $this->lineList;
    }

    /**
     * @param array|ProtocolLine[] $lineList
     * @return Protocol
     */
    public function setLineList(array $lineList): Protocol
    {
        $this->lineList = $lineList;
        return $this;
    }

    /**
     * @return bool
     */
    public function getSentFlag(): bool
    {
        return $this->sentFlag;
    }

    /**
     * @param bool $sentFlag
     * @return Protocol
     */
    public function setSentFlag(bool $sentFlag): Protocol
    {
        $this->sentFlag = $sentFlag;
        return $this;
    }

    /**
     * @return DateTimeImmutable|null
     */
    public function getSentDate(): ?DateTimeImmutable
    {
        return $this->sentDate;
    }

    /**
     * @param DateTimeImmutable|null $sentDate
     * @return Protocol
     * @deprecated Do not use this, because it is set automatically on the server-side. Will be reset anyway. {@see Protocol::onPreSerialize()}
     */
    public function setSentDate(?DateTimeImmutable $sentDate): Protocol
    {
        $this->sentDate = $sentDate;
        return $this;
    }

    /**
     * @return DateTimeImmutable|null
     */
    public function getCreateDate(): ?DateTimeImmutable
    {
        return $this->createDate;
    }

    /**
     *
     * @param DateTimeImmutable|null $createDate
     * @return Protocol
     * @deprecated Do not use this, because it is set automatically on the server-side. Will be reset anyway. {@see Protocol::onPreSerialize()}
     */
    public function setCreateDate(?DateTimeImmutable $createDate): Protocol
    {
        $this->createDate = $createDate;
        return $this;
    }


    /**
     * @return string
     */
    public function getSource(): string
    {
        return $this->source;
    }

    /**
     * @param string $source
     * @return Protocol
     */
    public function setSource(string $source): Protocol
    {
        $this->source = $source;
        return $this;
    }

    /**
     * @Serializer\PreSerialize()
     */
    public function onPreSerialize(): void
    {
        $this->id = null;

        if (empty($this->lineList)) {
            $this->lineList = [];
        }

        $this->sentFlag = false;
        $this->sentDate = null;
        $this->createDate = null;
    }
}
