#!/usr/bin/env bash
set -e

#################################################################
#
# This script should only be executed within the leader instance!
#
#################################################################

. /opt/elasticbeanstalk/support/envvars

cd $(cd $(dirname $0); echo $PWD)
cd ..

set -xe

if [ "$APP_INSTALL" == "true" ]; then

    echo "Application create database start..."

    #
    # Create databases before application is deployed
    #
    php bin/console doctrine:database:create --no-interaction

    echo "Application create database done."

else
    echo "If you want to create the databases, go to configuration - software configuration - environment variables and set APP_INSTALL to true."
fi
