<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Api\Configuration;

use Exception;
use SimpleSAML\Configuration;

/**
 * Class Manager
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Api\Configuration
 */
class Manager
{
    /**
     * @var array
     */
    private $factory = array();

    /**
     * @return Client
     */
    public function client()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Client($this->configuration()));
    }

    /**
     * @return Cyphering
     */
    public function cyphering()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Cyphering($this->configuration()));
    }

    /**
     * @return Security
     */
    public function security()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Security($this->configuration()));
    }

    /**
     * @return Configuration
     * @throws Exception
     */
    private function configuration()
    {
        return Configuration::getInstance();
    }
}
