<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Model\Request\User;

use SimpleSAML\Module\lifestyle\Webservice\Model\Request\User\PostApplicationAttributes\ApplicationType;
use SimpleSAML\Module\lifestyle\Webservice\Model\Request\User\PostApplicationAttributes\Request;

/**
 * Class Factory
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Model\Request\User
 */
class Factory
{
    /**
     * @param string $username
     * @return Request
     */
    public function postApplicationAttributesRequest($username)
    {
        return new Request($username);
    }

    /**
     * @param string $name
     * @return ApplicationType
     */
    public function postApplicationAttributesApplicationType($name)
    {
        return new ApplicationType($name);
    }
}
