<?php

use SimpleSAML\Configuration;
use SimpleSAML\Module\lifestyle\Utils\UrlBuilder;

$templatePathPrefix = 'lifestyle';

$urlBuilder = new UrlBuilder(
    Configuration::getInstance(),
    $_REQUEST['AuthState'],
    $this->getLanguage()
);

$this->data['header'] = $this->t('{login:user_pass_header}');

$this->includeAtTemplateBase($templatePathPrefix . ':includes/header.php');
?>

    <div class="container" role="main">

        <?php $this->includeAtTemplateBase($templatePathPrefix . ':includes/deprecatedBrowsers.php'); ?>

        <div class="row center">
            <div class="col-xs-12 hidden-xs">
                <h1><?php echo $this->t('{lifestyle:login:header_headline_mfa}'); ?></h1>
                <p><?php echo $this->t('{lifestyle:mfa:mfa_header_text}'); ?></p>
            </div>
            <div class="col-xs-12 visible-xs">
                <h1><?php echo $this->t('{lifestyle:login:header_headline_mfa_mobile}'); ?></h1>
            </div>
        </div>

        <?php if ($this->data['errorcode'] !== NULL): ?>
            <div class="row center">
                <div class="col-xs-12">
                    <div class="alert alert-danger">
                        <?php echo htmlspecialchars($this->t('{lifestyle:errors:title_' . $this->data['errorcode'] . '}', $this->data['errorparams'])); ?>
                        <br/>
                        <?php echo htmlspecialchars($this->t('{lifestyle:errors:descr_' . $this->data['errorcode'] . '}', $this->data['errorparams'])); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($this->data['mfa_qr_code']): ?>
            <div class="row center">
                <div class="col-xs-12">
                    <p><?php echo $this->t('{lifestyle:mfa:mfa_qr_code}'); ?></p>
                </div>
                <div class="col-xs-12" style="margin-bottom: 20px">
                    <img src="<?php echo $this->data['mfa_qr_code']; ?>"/>
                </div>
            </div>
        <?php endif; ?>

        <div class="row center">
            <div class="col-xs-12">
                <form method="post" action="?" id="login" class="form-decorators-js form-mfa-js">
                    <div class="form-group">
                        <?php $mfaHtmlId = 'id' . mt_rand(); ?>
                        <label for="<?php echo $mfaHtmlId ?>"
                               class="labelForm"><?php echo $this->t('{lifestyle:mfa:mfa_token}'); ?></label>
                        <input type="hidden" value="" name="mfa_token" id="mfa_token" autocomplete="off">
                        <input type="text" value="" class="form-control" name="<?php echo $mfaHtmlId ?>"
                               id="<?php echo $mfaHtmlId ?>" autocomplete="off"
                               onkeyup="document.getElementById('mfa_token').value = this.value;">
                        <div class="error mfatoken"></div>
                    </div>

                    <div class="text-center">
                        <button class="btn btn-submit-js w100" disabled="disabled"
                                onclick="$(this).closest('form').find('button[type=submit]').click();return false;">
                            <span class="icons icon-lock" aria-hidden="true"></span>
                            <p><?php echo $this->t('{lifestyle:login:submit}'); ?></p>
                        </button>
                        <button type="submit" class="hidden">not-empty</button>
                    </div>
                    <p class="visible-xs"><?php echo $this->t('{lifestyle:mfa:mfa_header_text}'); ?></p>
                    <a href="<?php echo $urlBuilder->getMfaForgottenUrl(); ?>"><?php echo $this->t('{lifestyle:mfa:mfa_forgotten_button}'); ?></a>
                    <a href="<?php echo $urlBuilder->getPrivacyUrl(); ?>"><?php echo $this->t('{lifestyle:login:footer_privacy_link}'); ?></a>

                    <?php
                    foreach ($this->data['stateparams'] as $name => $value) {
                        echo('<input type="hidden" name="' . htmlspecialchars($name) . '" value="' . htmlspecialchars($value) . '" />');
                    }
                    ?>

                </form>
            </div>
        </div>

    </div>

    <script>
        (function () {
            var init = function () {

                if (typeof ($) === 'undefined') {
                    window.setTimeout(init, 250);
                    return;
                }

                window.loginForm = $('#login')
                    .bootstrapValidator({
                        submitButtons: 'button[type="submit"]',
                        feedbackIcons: {
                            valid: 'icons icon-check-big',
                            invalid: 'icons icon-warning',
                            validating: 'icons icon-refresh'
                        },
                        fields: {
                            "<?php echo $mfaHtmlId ?>": {
                                container: '.error.mfatoken',
                                validators: {
                                    notEmpty: {
                                        message: '<?php echo $this->t('{lifestyle:login:mfatokenNotEmpty}'); ?>'
                                    }
                                }
                            }
                        }
                    });
            };

            init();
        })();
    </script>

<?php
$this->includeAtTemplateBase($templatePathPrefix . ':includes/footer.php');
