<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace AppBundle\Controller;

use Sso\Component\IdentifyServiceBundle\Api\Manager as ApiManager;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Symfony\Component\Routing\Annotation\Route;

/**
 * Class HelpController
 *
 * DO NOT ADD THIS TO staging OR prod ENVIRONMENT FOR SECURITY REASONS!
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package AppBundle\Controller
 */
class HelpController extends AbstractController
{
    /**
     * @var ApiManager
     */
    private $apiManager;

    /**
     * DefaultController constructor.
     * @param ApiManager $apiManager
     */
    public function __construct(ApiManager $apiManager)
    {
        $this->apiManager = $apiManager;
    }

    /**
     * Default service action - returns basic usage information
     *
     * This page is only available in development
     *
     * @Route("/", methods={"GET", "HEAD"})
     */
    public function help()
    {
        if (!$this->getParameter('kernel.debug')) {
            throw new AccessDeniedHttpException();
        }

        $sessionLifetime = new \DateTime();
        $sessionLifetime->add(new \DateInterval("PT1H"));

        // Create success request
        $getRequestSuccess = $this->apiManager->request()
                ->create()
                ->setCredentials()
                ->addGetAction('JohnDoe', 'secre_T8')
                ->buildXml();

        // Create success response
        $getResponseSuccess = $this->apiManager->response()
                ->create()
                ->addGetAction('Success', 'ff9f74cda48aa0892627f026e22194952da0529050687d077d7a01c3753f4f62e2c62a429c13796f2caced8a1d51dc6e6051217711bc41c1a609cb250f811196', $sessionLifetime)
                ->setStatus('Success')
                ->setTrackId('d3c7fcc7ec')
                ->buildXml();

        // Create error response
        $getResponseError = $this->apiManager->response()
                ->create()
                ->addGetAction('Failure', '')
                ->setStatus('Failure')
                ->setTrackId('241abbb937')
                ->addError('ui001', 'ui011', 'Invalid credentials', 'Wrong username or password')
                ->buildXml();

        // Create success request
        $validateRequestSuccess = $this->apiManager->request()
                ->create()
                ->addValidateAction('JohnDoe', '34211de5c4aa76564fc5e3657a7946aab3745be60a773117568b3e67a2223a2c6878e5d25ee70588b19728f010417388f590128beced60402c7b8036b725ba71')
                ->buildXml();

        // Create success response
        $validateResponseSuccess = $this->apiManager->response()
                ->create()
                ->addValidateAction('Success', '34211de5c4aa76564fc5e3657a7946aab3745be60a773117568b3e67a2223a2c6878e5d25ee70588b19728f010417388f590128beced60402c7b8036b725ba71', $sessionLifetime)
                ->setStatus('Success')
                ->setTrackId('c659c30781')
                ->buildXml();

        // Create error response
        $validateResponseError = $this->apiManager->response()
                ->create()
                ->addValidateAction('Failure', '')
                ->addError('ui002', 'ui021', 'Invalid credentials', 'Wrong username or user-identifier')
                ->setStatus('Failure')
                ->setTrackId('3a269b0a7d')
                ->buildXml();

        return $this->render('help/index.html.twig', array(
            'getRequestSuccess' => $getRequestSuccess,
            'getResponseSuccess' => $getResponseSuccess,
            'getResponseError' => $getResponseError,
            'validateRequestSuccess' => $validateRequestSuccess,
            'validateResponseSuccess' => $validateResponseSuccess,
            'validateResponseError' => $validateResponseError
        ));
    }
}
