<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace AppBundle\Entity;

require_once dirname(__DIR__) . '/Simplesamlphp/Session.php';

use Doctrine\ORM\Mapping as ORM;

/**
 * Class Session
 *
 * @ORM\Table(name="idp_kvstore",indexes={
 *     @ORM\Index(name="idp_kvstore_expire", columns={"_expire"}),
 *     @ORM\Index(name="idp_kvstore_uid", columns={"_extra", "_expire"})
 * })
 * @ORM\Entity(repositoryClass="AppBundle\Entity\SessionRepository")
 * @package AppBundle\Entity
 */
class Session
{
    const SESSION_OBJECT_IDENTIFIER = 'C%3A18%3A%22SimpleSAML%5CSession%22';

    /**
     * @ORM\Column(name="_key", length=50)
     * @ORM\Id()
     * @ORM\GeneratedValue(strategy="NONE")
     *
     * @var string
     */
    private $id;

    /**
     * @ORM\Column(name="_type", length=30)
     * @ORM\Id()
     *
     * @var string
     */
    private $type;

    /**
     * @ORM\Column(name="_value", type="text", nullable=false)
     *
     * @var string
     */
    private $value;

    /**
     * @ORM\Column(name="_expire", type="datetime", nullable=false)
     *
     * @var \DateTime
     */
    private $expire = 'CURRENT_TIMESTAMP';

    /**
     * @ORM\Column(name="_extra", type="string", length=128, nullable=true)
     *
     * @var string
     */
    private $extra;

    /**
     * @var \SimpleSAML\Session
     */
    private $data = false;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @return \DateTime
     */
    public function getExpire()
    {
        return $this->expire;
    }

    /**
     * @return string
     */
    public function getExtra()
    {
        return $this->extra;
    }

    /**
     * Get session data
     *
     * @return null|\SimpleSAML\Session
     */
    private function getData()
    {
        if (false === $this->data) {
            $this->data = 0 === strpos($this->value, static::SESSION_OBJECT_IDENTIFIER) ? unserialize(urldecode($this->value)) : null;
        }
        return $this->data;
    }

    /**
     * @return string|bool
     */
    private function getSessionAttributeAsString($attributeName)
    {
        if (null === ($sessionData = $this->getData())) {
            return false;
        }
        if (!($attributeValues = $sessionData->getAttribute($attributeName))) {
            return false;
        }
        return is_array($attributeValues) ? (string)reset($attributeValues) : (string)$attributeValues;
    }

    /**
     * @return string|bool
     */
    public function getUserIdentifier()
    {
        return $this->getSessionAttributeAsString('useridentifier');
    }

    /**
     * @return bool|string
     */
    public function getUsername()
    {
        return $this->getSessionAttributeAsString('username');
    }
}
