<?php
/**
 * User model 
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace AppBundle\Entity;

/**
 * User
 */
class User extends Base
{

    /**
     * Username
     * 
     * @var string
     */
    private $Username;

    /**
     * Plain password
     * 
     * @var string
     */
    private $Password;

    /**
     * UserIdentifier
     * 
     * @var string
     */
    private $UserIdentifier;

    /**
     * SessionLifetime
     * 
     * @var integer
     */
    private $SessionLifetime;

    /**
     * Set Username
     *
     * @param string $Username
     * @return User
     */
    public function setUsername($Username)
    {
        $this->Username = $Username;
        $this->_setChanged('Username');

        return $this;
    }

    /**
     * Get Username
     *
     * @return string 
     */
    public function getUsername()
    {
        return $this->Username;
    }

    /**
     * Set Password
     *
     * @param string $Password
     * @return User
     */
    public function setPassword($Password)
    {
        $this->Password = (string) $Password;
        $this->_setChanged('Password');

        return $this;
    }

    /**
     * Get Password
     *
     * @return string 
     */
    public function getPassword()
    {
        return $this->Password;
    }

    /**
     * Set UserIdentifier
     *
     * @param string $UserIdentifier
     * @return User
     */
    public function setUserIdentifier($UserIdentifier)
    {
        $this->UserIdentifier = (string) $UserIdentifier;
        $this->_setChanged('UserIdentifier');

        return $this;
    }

    /**
     * Get UserIdentifier
     *
     * @return string 
     */
    public function getUserIdentifier()
    {
        return $this->UserIdentifier;
    }

    /**
     * Set SessionLifetime as unix timestamp
     *
     * @param integer $SessionLifetime
     * @return User
     */
    public function setSessionLifetime($SessionLifetime)
    {
        $this->SessionLifetime = $SessionLifetime;
        $this->_setChanged('SessionLifetime');

        return $this;
    }

    /**
     * Get SessionLifetime as unix timestamp
     *
     * @return integer|null 
     */
    public function getSessionLifetime()
    {
        return $this->SessionLifetime;
    }

}
